# delimit ;
capture log close;
set more 1;  
clear; 
set mem 300m; 
local divide 2; 
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;

global folder "D:\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "C:\research";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "~/";

         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
	 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
	 local wave9d "$folder\hrs\wave9\";
	 local wave10d "$folder\hrs\wave10\";
	 local wave11d "$folder\hrs\wave11\";
	 local wave12d "$folder\hrs\wave12\";
	 local wave13d "$folder\hrs\wave13\";
	 local wave14d "$folder\hrs\wave14\";
	 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";

log using "`saved'asset.log", replace;  



***** HRS WAVE1******************************************;



 

clear;

set memory 300m;
use `wave1d'househld;

*house asset;
replace V605=0 if V605==.;
replace V612=0 if V612==.;
replace V619=0 if V619==.;
replace V632=0 if V632==.;

gen house1=V605+V612+V619+V632+V712;

****************************************

comment: The structure of the questionair in hrs wave1 is different from those of other hrs

waves. The house1 varibale defines the gross vaule of the first home, which may be 100% owned fram/ranch(v605), 

partially owned fram/ranch(v612), or so.;



*house mortgage; 

replace V723=0 if V723==.;
replace V730=0 if V730==.;
replace V736=0 if V736==.;
replace V744=0 if V744==.;
gen mort1=V723+V730+V736+V744; 

*real estate;   

replace V5202=0 if V5202==.;
replace V824=0 if V824==.; * V824 is value of second home, which seems subsumed in V5202;
gen re1=V5202+V824;

*****************************

comment: V5202 is the net vaule of real estates other than first and second homes.;  

*real estate mortgage;


replace V826=0 if V826==.;
rename V826 remort1;

************************

*comment: V826 is the debt on the second home.; 

    

*business;

rename V5357 bus1;

*****************

comment: bus1=net value of business, instead of the value of business or farm;         

*IRA;

rename V5355 IRA1;     

*stock;

rename V5356 stock1;      

*bonds;

rename V5358 bonds1;      

*liquid assets;

gen liquid1=V5222+V5226;    

*transportation assets;

gen wheels1=V5353; 
summ wheels1;       

*trust;

******comment: unlike the cases of other HRS waves, the data for "trust" variable is not available for this wave. Therefore, the value of "trust" variable would be included in "exasset" variable.;

gen trust1=.;        

*other assets;

rename V5359 exasset1;       

*debts;

rename V5360 debts1; 

*generate  total non-house asset;   

gen nohouse1=re1+wheels1+liquid1+IRA1+stock1+bus1+bonds1+exasset1-debts1-remort1;

*generate total asset;

gen assets1=house1+nohouse1-mort1;

*keep asset variables;

*generate equivalent of PN variable from other files;

gen PN = real(APN_FIN);

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

keep HHID PN house1  re1 mort1 remort1 wheels1 liquid1 IRA1 stock1 bus1 bonds1 trust1 exasset1 debts1 nohouse1 assets1; 

summ;

sort HHID PN; 

sleep 1000;
save `saved'asset, replace;

drop _all; 





********* HRS WAVE2*****************************************************;



clear;

set memory 300m;

use `wave2d'w2d;

*generate variable for 1994 sub-household identifier to match name in old files;

gen W2SUBHH = real(CSUBHH);

*generate variable for 1994 financial respondent identifier to match name in old files;

gen PN = real(CPN_FIN);

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

keep HHID W2SUBHH PN;

sort HHID W2SUBHH; * this is for merging an individual file to a family file; 
sleep 1000;
save `saved'temp, replace;

drop _all;

clear;

set memory 300m;

*change filename that is used from h1994id (which doesn't exist in the new files) to h94i_d (the suspected new equivalent);
*use `wave2d'h1994id;
use `wave2d'h94i_d;




sort HHID W2SUBHH;

merge HHID W2SUBHH using `saved'temp;

drop _merge;

sort HHID W2SUBHH;
sleep 1000;
save `saved'temp, replace;

drop _all;

clear;

set memory 300m;

*change filename that is used from h1994ik (which doesn't exist in the new files) to h94i_k (the suspected new equivalent);
*use `wave2d'h1994ik;
use `wave2d'h94i_k;

sort HHID W2SUBHH; 

merge HHID W2SUBHH using `saved'temp;

drop _merge;

sort HHID PN; 



*gross house asset, not net value;

rename W614X house2; 

*house mortgage; 

gen mort2=W622X+W626X+W631X+W635X; 

*real estate;   

gen re2=W718X+W5501X;  

*real estate mortgage: amount owed on the second home, or say real estate;

gen remort2=W721X;     

********************************

comment: The questionair about mortgage on the real estate, or second home, is

different from hrs 1996, wave3.;



*business or farm;

rename W5506X bus2;         

*IRA;

rename W5509X IRA2;

******************

comment: the IRA amount including amounts in all IRA acccounts.;     

*stock;

rename W5512X stock2;      

*bonds;

rename W5521X bonds2;      

*liquid assets;

gen liquid2=W5515X+W5518X;    

*transportation assets;

rename W5503X wheels2;        

*trust;

rename W5563X trust2;         

*other assets;

rename W5524X exasset2;       

*debts;

rename W5527X debts2; 

*generate  total non-house asset;   

gen nohouse2=re2+wheels2+liquid2+IRA2+stock2+bus2+bonds2+exasset2-debts2-remort2;

*generate total asset;

gen assets2=house2+nohouse2-mort2;

*keep asset variables;

keep HHID PN house2 re2 mort2 remort2 wheels2 liquid2 IRA2 stock2 bus2 bonds2 trust2 exasset2 debts2 nohouse2 assets2;


sort HHID PN; 

merge HHID PN using `saved'asset; 

drop _merge; 

summ;


sort HHID PN; 
sleep 1000;
save `saved'asset, replace;

drop _all; 





*********HRS WAVE3*******************************************;

 

clear;

set memory 300m;

*change filename that is used from h1996i_e (which doesn't exist in the new files) to h96i_er (the suspected new equivalent);
*use `wave3d'h1996i_e;
use `wave3d'h96i_er;

*comment: get PN from the above file;

keep HHID ESUBHH PN;

sort HHID ESUBHH; 
sleep 1000;
save `saved'temp, replace;

drop _all;

clear;

set memory 300m;

*change filename that is used from h1996i_f (which doesn't exist in the new files) to h96i_fh (the suspected new equivalent);
*use `wave3d'h1996i_f;
use `wave3d'h96i_fh;

*comment: get housing and real estate data from above file;

sort HHID ESUBHH;

merge HHID ESUBHH using `saved'temp;

drop _merge;

sort HHID ESUBHH;
sleep 1000;
save `saved'temp, replace;

drop _all;

clear;

set memory 300m;

*change filename that is used from h1996i_j (which doesn't exist in the new files) to h96i_jh (the suspected new equivalent);
*use `wave3d'h1996i_j;
use `wave3d'h96i_jh;

*comment: get asset data from the above file;

sort HHID ESUBHH; 

merge HHID ESUBHH using `saved'temp;

drop _merge;

sort HHID PN; 



*house asset;

rename E2246X house3; 

*house mortgage; 

gen mort3=E2256X+E2263X+E2270X+E2277X; 

*real estate;   

gen re3=E2435X+E4071X;  

*real estate mortgage;

gen remort3=E2445X+E2459X+E2466X;     

********************************

comment: For each observation,  E2452 variable(owed on the second mortgage) has missing values, and the bracket-unfolding variables for it all have missing

values too;



*business or farm;

rename E4097X bus3;         

*IRA;

gen IRA3=E4127X+E4149X+E4171X;     

*stock;

rename E4340X stock3;      

*bonds;

rename E4383X bonds3;      

*liquid assets;

gen liquid3=E4426X+E4465X;    

*transportation assets;

rename E4501X wheels3;        

*trust;

rename E4713X trust3;         

*other assets;

rename E4514X exasset3;       

*debts;

rename E4727X debts3; 

*generate  total non-house asset;   

gen nohouse3=re3+wheels3+liquid3+IRA3+stock3+bus3+bonds3+exasset3-debts3-remort3;

*generate total asset;

gen assets3=house3+nohouse3-mort3;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

*keep asset variables;

keep HHID PN house3  re3 mort3 remort3 wheels3 liquid3 IRA3 stock3 bus3 bonds3 trust3 exasset3 debts3 nohouse3 assets3; 


sort HHID PN; 

merge HHID PN using `saved'asset; 

drop _merge; 

summ;

sort HHID PN; 
sleep 1000;
save `saved'asset, replace;

drop _all; 





************* HRS WAVE4************************************************************;

*this section was altered significantly;
*in the old asset.do the file hrs98f was used, with only the variables HHID, FSUBHH, and PN saved, and then used as a basis for merging;
*since no non-ID variables were kept from this file, I cut it;
*then I merged h98i_fh and h98i_jh (which are the replacements for h1998i_f and h1998i_j);
*sorting by HHID and FSUBHH;
*rather than HHID and PN; 
*since h98i_fh doesn't have the PN variable;
*all of the commented-out code is included in the file "copy of asset", saved on april 22nd; 
*I cut the old code out of here because for some reason it wasn't running with all of the commented-out stuff in here;


clear;

set memory 300m;

use `wave4d'h98i_fh;

gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(FSUBHH);
drop FSUBHH;
gen FSUBHH=temp; 
drop temp;

sort HHID FSUBHH;
sleep 1000;
save `saved'temp, replace;


drop _all;

clear;

set memory 300m;

use `wave4d'h98i_jh;

gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(FSUBHH);
drop FSUBHH;
gen FSUBHH=temp; 
drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;


sort HHID FSUBHH;

merge HHID FSUBHH using `saved'temp;


drop _merge;

sort HHID PN; 

*gross house asset, not net value;

*rename variable F2760X to match variable name in old files;
rename F2760X Q2760X;
rename Q2760X house4; 

*house mortgage; 

*rename variables F2773X, FQ2780X, F2787X, and F2794X to match variable names in old files;
rename F2773X Q2773X;
rename F2780X Q2780X;
rename F2787X Q2787X;
rename F2794X Q2794X;
gen mort4=Q2773X+Q2780X+Q2787X+Q2794X; 

*real estate;   

*rename variables F2950X AND F4831X to match variable names in old files;
rename F2950X Q2950X;
rename F4831X Q4831X;
gen re4=Q2950X+Q4831X;  

*real estate mortgage: amount owed on the second home, or say real estate;

*rename variable F2957X to match variable name in old files;
rename F2957X Q2957X;
gen remort4=Q2957X;     

********************************

comment: The questionair about mortgage on the real estate, or second home, is

different from hrs 1996, wave3.;



*business or farm;

*rename F4857X to match variable name in old files;
rename F4857X Q4857X;
rename Q4857X bus4;         

*IRA;

*rename F4887X, F4909X, and F4930X to match variable names in old files;
rename F4887X Q4887X;
rename F4909X Q4909X;
rename F4930X Q4930X;
gen IRA4=Q4887X+Q4909X+Q4930X;     

*stock;

*rename F5100X to match variable name in old files;
rename F5100X Q5100X;
rename Q5100X stock4;      

*bonds;

*rename F5143X to match variable name in old files;
rename F5143X Q5143X;
rename Q5143X bonds4;      

*liquid assets;

*rename F5186X and F5225X to match variable names in old files;
rename F5186X Q5186X;
rename F5225X Q5225X;
gen liquid4=Q5186X+Q5225X;    

*transportation assets;

*rename F5261X to match variable name in old files;
rename F5261X Q5261X;
rename Q5261X wheels4;        

*trust;

*rename F5473X to match variable name in old files;
rename F5473X Q5473X;
rename Q5473X trust4;         

*other assets;

*rename F5274X to match variable name in old files;
rename F5274X Q5274X;
rename Q5274X exasset4;       

*debts;

*rename F5487X to match variable name in old files;
rename F5487X Q5487X;
rename Q5487X debts4; 

*generate  total non-house asset;   

gen nohouse4=re4+wheels4+liquid4+IRA4+stock4+bus4+bonds4+exasset4-debts4-remort4;

*generate total asset;

gen assets4=house4+nohouse4-mort4;


*commented out the following section because the current values of PN and HHID are already in real form;
*gen temp=real(HHID);
*drop HHID;
*gen HHID=temp;
*drop temp;
*gen temp=real(PN);
*drop PN;
*gen PN=temp;
*drop temp;

*keep asset variables;

keep Q2950X Q4831X HHID PN house4 re4 mort4 remort4 wheels4 liquid4 IRA4 stock4 bus4 bonds4 trust4 exasset4 debts4 nohouse4 assets4;


sort HHID PN; 

merge HHID PN using `saved'asset; 

drop _merge; 

summ;

sort HHID PN; 
sleep 1000;
save `saved'asset, replace;

drop _all; 





*------------------------------------------;

*-----The beginning of 2000 data-----------;

*------------------------------------------;

clear;

set memory 300m;

*change filename that is used from h00_cs (which doesn't exist in the new files) to H00CS_R (the suspected new equivalent);
*use `wave5d'h00_cs; * get some cover-screen data from the file;
use `wave5d'H00CS_R; * get some cover-screen data from the file;
*use `wave5d'x00CS_R; * get some cover-screen data from the file;



*rename G760, G558, G794, G821, and G597 to match variable names in old files.;
rename G760 Q760;
rename G558 Q558;
rename G794 Q794;
rename G821 Q821;
rename G597 Q597;
keep HHID PN GSUBHH Q760 Q558 Q794 Q821 Q597;

sort HHID PN;
sleep 1000;
save `saved'temp, replace;



clear;

set memory 300m;

*change filename that is used from h00_a (which doesn't exist in the new file) to H00A_R (the suspected new equivalent);
*use `wave5d'h00_a; * get some demographic data from the file;
use `wave5d'H00A_R; * get some demographic data from the file;


*rename G1101 and G1102 to match variable names in old files;
rename G1101 Q1101;
rename G1102 Q1102;
keep HHID PN GSUBHH Q1101 Q1102;

sort HHID PN;

merge HHID PN using `saved'temp;

drop _merge;

sort HHID PN;
sleep 1000;
save `saved'temp, replace;



clear;

set memory 300m;

*change filename that is used from h00_pr (which doesn't exist in the new file) to H00PR_R (the suspected new equivalent);
*use `wave5d'h00_pr; * get some PR data from the file;
use `wave5d'H00PR_R; * get some PR data from the file;

*rename G128, G120, G116, G118, G113, G114, G119, G115, G124, G121, and G117 to match variable names in old files;
rename G128 Q128;
rename G120 Q120;
rename G116 Q116;
rename G118 Q118;
rename G113 Q113;
rename G114 Q114;
rename G119 Q119;
rename G115 Q115;
rename G124 Q124;
rename G121 Q121;
rename G117 Q117;

keep HHID PN PN Q128 Q120 Q116 Q118 Q113 Q114 Q119 Q115 Q124 Q121 Q117;

sort HHID PN;

merge HHID PN using `saved'temp;

drop _merge;

sort HHID PN;
sleep 1000;
save `saved'temp, replace;



clear;

set memory 300m;

*change filename that is used from h2000i_f (which doesn't exist in the new file) to H00i_fh (the suspected new equivalent);
*use `wave5d'h2000i_f;
use `wave5d'h00i_fh;

sort HHID PN;

merge HHID PN using `saved'temp;

* the above statement gets some cover-screen data from the above file;

drop _merge;

gen wave=5;



* impute Q3071;

* mobile home value;


* impute Q3078;

* home value;

* gross value of the first home;

*rename G3078X and G3071X to match variable names in old files;
rename G3078X Q3078X;
rename G3071X Q3071X;
gen house5=Q3078X+Q3071X;

summ house5 Q3078X Q3071X;


*********************

comment: The flow of the questionnaire of this hrs wave is different from those of 

other hrs waves. In this wave, values of two types of first homes are calculated separately.

Therefore, house5=Q3078X+Q3071X;



*impute Q3091;

*Q3091 is $ OWE ON FIRST MORTGAGE;



*impute Q3098;
* owe on 2nd mort;


*impute Q3105;
* owe on loan?;



*impute Q3112;
* owe eqity loan;

*house mortgage;

*rename G3091X, G3098X, G3105X, AND G3112X to match variable names in old files;
rename G3091X Q3091X;
rename G3098X Q3098X;
rename G3105X Q3105X;
rename G3112X Q3112X;
gen mort5=Q3091X+Q3098X+Q3105X+Q3112X;



*wave5 equivalent of Q2950(W4) is Q3268;

*Q3268 is $ VALUE 2ND HOME;

*impute Q3268;
* part of real estate: value of second home;

*rename G3268X to match variable name in old files;
rename G3268X Q3268X;
rename Q3268X re5;


*impute Q3275;
* owe 2nd home;

*rename G3275X to match variable name in old files;
rename G3275X Q3275X;
gen remort5=Q3275X;



keep HHID PN GSUBHH house5 mort5 re5 remort5 Q760 Q558 Q794 Q821 Q597 Q1101 Q1102 Q128 Q120 Q116 Q118 Q113 Q114 Q119 Q115 Q124 Q121 Q117;

sort HHID PN;
sleep 1000;
save `saved'temp, replace;

drop _all;



******************** non-housing part of assets ***************;

clear;

set memory 300m;

*change filename that is used from h2000i_j (which doesn't exist in the new file) to H00i_jh (the suspected new equivalent);
*use `wave5d'h2000i_j.dta; * This is using the 'Assets and Income' file from Wave5;
use `wave5d'h00i_jh.dta; * This is using the 'Assets and Income' file from Wave5;

sort HHID PN;

merge HHID PN using `saved'temp;

drop _merge;

*rename G5682X to match variable name in old files;
rename G5682X Q5682X;
rename Q5682X wheels5;

*Wheels5 is the net worth of automobiles;

*impute wheels5;



*Q5621 is the total value of checking and savings accounts;

*Q5621 is the Wave5 equivalent of Q5186(W4);

*impute Q5621;
* checking


*Q5651 is the dollar worth of CDs;

*impute Q5651;

*liqid asset;

*rename G5651X and G5621X to match variable names in old files;
rename G5651X Q5651X;
rename G5621X Q5621X;
gen liquid5=Q5651X+Q5621X;



*Q5332 is the TOTAL $ IRA ACCOUNT; 


*Q5354 is the TOTAL $ IRA ACCOUNT-2;

*impute Q5354;



*Q5375 is the TOTAL $ IRA ACCOUNT-3;

*impute Q5375;





*IRA;

*rename G5332X, G5354X, and G5375X to match variable names in old files;
rename G5332X Q5332X;
rename G5354X Q5354X;
rename G5375X Q5375X;
gen IRA5=Q5332X+Q5354X+Q5375X;



*impute Q5555;

* stocks;

*rename G5555X to match variable name in old files;
rename G5555X Q5555X;
rename Q5555X stock5;



*Q5302 is the Wave5 equivalent to Q4856 - BUSINESS OR FARM $;

*impute Q5302;

*business or farm;

*rename G5302X to match variable name in old files;
rename G5302X Q5302X;
rename Q5302X bus5;



*Q5588 is the Wave5 equivalent to Q5143;

*impute Q5588; 

*bonds;

*rename G5588X to match variable name in old files;
rename G5588X Q5588X;
rename Q5588X bonds5;



*Q5695 is the Wave5 equivalent to Q5274(W4);

*other assets;

* impute exasset5;

*rename G5695X to match variable name in old files;
rename G5695X Q5695X;
rename Q5695X exasset5;



* impute Q5833;

*trusts;

*rename G5833X to match variable name in old files;
rename G5833X Q5833X;
rename Q5833X trust5;



*Q5847 is the Wave5 equivalent to Q5486(W4);

* impute Q5847;

* debts;

*rename G5847X to match variable name in old files;
rename G5847X Q5847X;
rename Q5847X debts5;








*Q5276, value of second home, is the Wave 5 equivalent to Q4831(W4);

* impute Q5276;

* other RE

* deactivate the initial re-coding;

* replace Q5276=0 if Q5275==5|Q5276==.|Q760~=1|Q5275==5|Q5275==8|Q5275==9;

* real estate;

*rename G5276X to match variable name in old files;
rename G5276X Q5276X;
replace re5=re5+Q5276X;

replace re5=-1 if re5<0; * Li's question: why we put such an lower bound on real estate;

gen nohouse5=re5+wheels5+liquid5+IRA5+stock5+bus5+bonds5+exasset5-debts5-remort5;

gen assets5=house5+nohouse5-mort5;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

keep HHID PN house5 mort5 re5 remort5 wheels5 liquid5 IRA5 stock5 bus5 bonds5 trust5 exasset5 debts5 nohouse5 assets5;

summ;

sort HHID PN;

merge HHID PN using `saved'asset;

drop _merge;

summ;


sort HHID PN;
sleep 1000;
save `saved'asset, replace;

*END OF EDITTING WAVE5;



*------------------------------------------;

*-----The beginning of 2002 data-----------;

*------------------------------------------;


clear;

set memory 300m;

use `wave6d'H02A_R; * get various demographics;

keep HHID PN HSUBHH HA019 HFINR HA028; *HA070; *removed HA070 because this variable doesn't exist in the new data;

sort HHID PN;

*merge HHID PN using `saved'temp;
*drop _merge;

sort HHID HSUBHH;
sleep 1000;
save `saved'temp, replace;

clear;

set memory 300m;

use `wave6d'H02i_hh;

sort HHID HSUBHH;

merge HHID HSUBHH using `saved'temp;

* sum if HHID=="052716";

* the above statement gets some financial data about housing assets;
* Note that the structure of this file is slightly different than previous waves.;
* In this file, we have everyone, instead of having only finanacial respondants.;
* The following statement makes this file like the previous ones;
*drop if HFINR ~= 1; *This may not be correct--need to check when I have access to the files;

* sum if HHID=="052716";

drop _merge;

gen wave=6;



* impute HH016;

* mobile home value;


* impute HH020;

* home value;

* gross value of the first home;

gen house6=HH016X+HH020X;

summ house6 HH016X HH020X;


*********************
*comment: The flow of the questionnaire of this hrs wave is different from those of ;
*other hrs waves (other than wave5). In this wave, values of two types of first homes ;
*are calculated separately.  Therefore, house6=HH016X+HH020X;



*impute HH032;

*HH032X is $ OWE ON FIRST MORTGAGE;



*impute HH042;
* owe on 2nd mort;


*impute HH052;
* owe on loan?;



*impute HH062;
* owe equity loan;

*house mortgage;

gen mort6=HH032X+HH042X+HH052X+HH062X;



*HH166 is $ VALUE 2ND HOME;

*impute HH166;
* part of real estate: value of second home;

rename HH166X re6;


*impute HH171;
* owe 2nd home;

gen remort6=HH171X;



keep HHID PN HSUBHH house6 mort6 re6 remort6;
* Q760 Q558 Q794 Q821 Q597 Q1101 Q1102 ;
sort HHID HSUBHH;

*sum if HHID=="052716";

sleep 1000;
save `saved'temp, replace;

drop _all;




******************** non-housing part of assets ***************;

clear;

set memory 300m;

use `wave6d'h02i_qh.dta; * This is using the 'Assets and Income' file from Wave6;

sort HHID HSUBHH;

merge HHID HSUBHH using `saved'temp;



drop _merge;

rename HQ371X wheels6;

*Wheels6 is the net worth of automobiles, planes, and boats;

*impute wheels6;



*HQ345 is the total value of checking and savings accounts;

*HQ345 is the Wave6 equivalent of Q5621(W5);

*impute HQ345;


*HQ357 is the dollar worth of CDs;

*impute HQ357;

*liqid asset;

gen liquid6=HQ345X+HQ357X;



*HQ166_1 is the TOTAL $ IRA ACCOUNT; 


*HQ166_2 is the TOTAL $ IRA ACCOUNT-2;

*impute HQ166_2;



*HQ166_3 is the TOTAL $ IRA ACCOUNT-3;

*impute HQ166_3;





*IRA;

gen IRA6=HQ166_1X+HQ166_2X+HQ166_3X;



*impute HQ317;

* stocks;

rename HQ317X stock6;



*HQ148 is the Wave6 equivalent to Q5302 - BUSINESS OR FARM $;

*impute HQ148;

*business or farm;

rename HQ148X bus6;



*HQ331 is the Wave6 equivalent to Q5588;

*impute HQ331; 

*bonds;

rename HQ331X bonds6;



*HQ376 is the Wave6 equivalent to Q5695(W5);

*other assets;

* impute exasset6;

rename HQ376X exasset6;



* impute HQ472X, HQ467x? - I added HQ467X as the previous trust was a lot lower than wave 5-this makes it look more reasonable;

*trusts;

gen trust6=HQ472X+HQ467X;



*HQ478 is the Wave6 equivalent to Q5847(W5);

* impute HQ478;

* debts;

rename HQ478X debts6;



*HQ134, value of other real estate, is the Wave 6 equivalent to Q5276(W5);

* impute HQ134;

* other RE

* deactivate the initial re-coding;

* replace HQ134=0 if HQ133==5|HQ134==.|HFINR~=1|HQ133==5|HQ133==8|HQ133==9;

* real estate;

replace re6=re6+HQ134X;

replace re6=-1 if re6<0; * Li's question: why we put such an lower bound on real estate;

gen nohouse6=re6+wheels6+liquid6+IRA6+stock6+bus6+bonds6+exasset6-debts6-remort6;

gen assets6=house6+nohouse6-mort6;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

keep HHID PN house6 mort6 re6 remort6 wheels6 liquid6 IRA6 stock6 bus6 bonds6 trust6 exasset6 debts6 nohouse6 assets6;

summ;

sort HHID PN;




merge HHID PN using `saved'asset;

drop _merge;

summ;


sort HHID PN;

sleep 1000;
save `saved'asset, replace;



*------------------------------------------;

*-----The beginning of 2004 data-----------;

*------------------------------------------;


clear;

set memory 300m;

use `wave7d'H04i_hh;

sort HHID JSUBHH;
sleep 1000;
save `saved'temp, replace;

use `wave7d'h04i_qh.dta;

sort HHID JSUBHH;

merge HHID JSUBHH using `saved'temp;

drop _merge;

sort HHID JSUBHH;
sleep 1000;
save `saved'temp, replace;

use `wave7d'H04A_R; * get various demographics;

keep HHID PN HSUBHH JSUBHH JA019 JFINR JA028; *JA070; *removed HA070 because this variable doesn't exist in the new data;

sort HHID PN;

sort HHID JSUBHH;

merge HHID JSUBHH using `saved'temp;

drop _merge;

*adhoc data fixes;

replace PN="020" if HHID=="082694";
replace JSUBHH="1" if (HHID=="082694")&(PN=="020");
replace HSUBHH="7" if (HHID=="082694")&(PN=="020");

replace PN="011" if (HHID=="087167")&(JSUBHH=="2");
replace JSUBHH="7" if (HHID=="087167")&(PN=="011");
replace HSUBHH="2" if (HHID=="087167")&(PN=="011");

replace PN="010" if (HHID=="087167")&(JSUBHH=="1");
replace JSUBHH="7" if (HHID=="087167")&(PN=="010");
replace HSUBHH="1" if (HHID=="087167")&(PN=="010");

replace PN="020" if HHID=="204425";
replace JSUBHH="1" if (HHID=="204425")&(PN=="020");
replace HSUBHH="7" if (HHID=="204425")&(PN=="020");


gen wave=7;



* impute JH016;

* mobile home value;


* impute JH020;

* home value;


* gross value of the first home;

gen house7=JH016X+JH020X;

summ house7 JH016X JH020X;


*impute JH032;

*JH032X is $ OWE ON FIRST MORTGAGE;



*impute JH042;
* owe on 2nd mort;


*impute JH052;
* owe on loan?;



*impute JH062;
* owe equity loan;

*house mortgage;

gen mort7=JH032X+JH042X+JH052X+JH062X;


*HH166 is $ VALUE 2ND HOME;

*impute JH166;
* part of real estate: value of second home;

rename JH166X re7;


*impute JH171;
* owe 2nd home;

gen remort7=JH171X;


rename JQ371X wheels7;


*JQ345 is the total value of checking and savings accounts;

*JQ345 is the Wave7 equivalent of Q5621(W5);

*impute JQ345;


*JQ357 is the dollar worth of CDs;

*impute JQ357;

*liqid asset;

gen liquid7=JQ345X+JQ357X;


*JQ166_1 is the TOTAL $ IRA ACCOUNT; 


*JQ166_2 is the TOTAL $ IRA ACCOUNT-2;

*impute JQ166_2;



*JQ166_3 is the TOTAL $ IRA ACCOUNT-3;

*impute JQ166_3;


*IRA;

gen IRA7=JQ166_1X+JQ166_2X+JQ166_3X;



*impute JQ317;

* stocks;

rename JQ317X stock7;


*JQ148 is the Wave7 equivalent to Q5302 - BUSINESS OR FARM $;

*impute JQ148;

*business or farm;

rename JQ148X bus7;



*JQ331 is the Wave7 equivalent to Q5588;

*impute JQ331; 

*bonds;

rename JQ331X bonds7;



*JQ376 is the Wave7 equivalent to Q5695(W5);

*other assets;

* impute exasset7;

rename JQ376X exasset7;



* impute JQ472X, JQ467x? - I added HQ467X as the previous trust was a lot lower than wave 5-this makes it look more reasonable;

*trusts;

gen trust7=JQ472X+JQ467X;



*JQ478 is the Wave7 equivalent to Q5847(W5);

* impute HQ478;

* debts;

rename JQ478X debts7;



*HQ134, value of other real estate, is the Wave 7 equivalent to Q5276(W5);

* impute HQ134;

* real estate;

replace re7=re7+JQ134X;

replace re7=-1 if re7<0; * Li's question: why we put such an lower bound on real estate;

gen nohouse7=re7+wheels7+liquid7+IRA7+stock7+bus7+bonds7+exasset7-debts7-remort7;

gen assets7=house7+nohouse7-mort7;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

keep HHID PN house7 mort7 re7 remort7 wheels7 liquid7 IRA7 stock7 bus7 bonds7 trust7 exasset7 debts7 nohouse7 assets7;

* ad hoc data fix;

replace house7=0 if house7==.;
replace mort7=0 if mort7==.;
replace re7=0 if re7==.;
replace remort7=0 if remort7==.;
replace wheels7=0 if wheels7==.;
replace liquid7=0 if liquid7==.;
replace IRA7=0 if IRA7==.;
replace stock7=0 if stock7==.;
replace bus7=0 if bus7==.;
replace bonds7=0 if bonds7==.;
replace trust7=0 if trust7==.;
replace exasset7=0 if exasset7==.;
replace debts7=0 if debts7==.;
replace nohouse7=0 if nohouse7==.;
replace assets7=0 if assets7==.;

collapse (sum) house7 mort7 re7 remort7 wheels7 liquid7 IRA7 stock7 bus7 bonds7 trust7 exasset7 debts7 nohouse7 assets7, by(HHID PN);

summ;

sort HHID PN;

*sort HHID PN;
*browse;
*exit;

merge HHID PN using `saved'asset;

drop _merge;

summ;

sort HHID PN;
sleep 1000;
save `saved'asset, replace;

*------------------------------------------;

*-----The beginning of 2006 data-----------;

*------------------------------------------;


clear;

set memory 300m;

use `wave8d'H06A_R; * get various demographics;

keep HHID PN;

* generate placeholders;

gen house8=.;
gen mort8=.;
gen re8=.;
gen wheels8=.;
gen liquid8=.;
gen IRA8=.;
gen stock8=.;
gen bus8=.;
gen bonds8=.;
gen trust8=.;
gen exasset8=.;
gen debts8=.;
gen nohouse8=.;
gen assets8=.;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

sort HHID PN;

merge HHID PN using `saved'asset;

drop _merge;

sort HHID PN;

sleep 1000;
save `saved'asset, replace;


*------------------------------------------;

*-----The beginning of 2008 data-----------;

*------------------------------------------;


clear;

set memory 300m;

use `wave9d'H08A_R; * get various demographics;

keep HHID PN;

* generate placeholders;

gen house9=.;
gen mort9=.;
gen re9=.;
gen wheels9=.;
gen liquid9=.;
gen IRA9=.;
gen stock9=.;
gen bus9=.;
gen bonds9=.;
gen trust9=.;
gen exasset9=.;
gen debts9=.;
gen nohouse9=.;
gen assets9=.;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

sort HHID PN;

merge HHID PN using `saved'asset;

drop _merge;

sort HHID PN;

sleep 1000;
save `saved'asset, replace;

*------------------------------------------;

*-----The beginning of 2010 data-----------;

*------------------------------------------;


clear;

set memory 300m;

use `wave10d'H10A_R; * get various demographics;

keep HHID PN;

* generate placeholders;

gen house10=.;
gen mort10=.;
gen re10=.;
gen wheels10=.;
gen liquid10=.;
gen IRA10=.;
gen stock10=.;
gen bus10=.;
gen bonds10=.;
gen trust10=.;
gen exasset10=.;
gen debts10=.;
gen nohouse10=.;
gen assets10=.;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

sort HHID PN;

merge HHID PN using `saved'asset;

drop _merge;

sort HHID PN;

sleep 1000;
save `saved'asset, replace;





*------------------------------------------;

*---------------- 2012 data----------------;

*------------------------------------------;


clear;

set memory 300m;

use `wave11d'H12A_R; * get various demographics;

keep HHID PN;

* generate placeholders;

gen house11=.;
gen mort11=.;
gen re11=.;
gen wheels11=.;
gen liquid11=.;
gen IRA11=.;
gen stock11=.;
gen bus11=.;
gen bonds11=.;
gen trust11=.;
gen exasset11=.;
gen debts11=.;
gen nohouse11=.;
gen assets11=.;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

sort HHID PN;

merge HHID PN using `saved'asset;

drop _merge;

sort HHID PN;

sleep 1000;
save `saved'asset, replace;


*------------------------------------------;


*------------------------------------------;

*---------------- 2014 data----------------;

*------------------------------------------;


clear;

set memory 300m;

use `wave12d'H14A_R; * get various demographics;

keep HHID PN;

* generate placeholders;

gen house12=.;
gen mort12=.;
gen re12=.;
gen wheels12=.;
gen liquid12=.;
gen IRA12=.;
gen stock12=.;
gen bus12=.;
gen bonds12=.;
gen trust12=.;
gen exasset12=.;
gen debts12=.;
gen nohouse12=.;
gen assets12=.;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

sort HHID PN;

merge HHID PN using `saved'asset;

drop _merge;

sort HHID PN;

sleep 1000;
save `saved'asset, replace;



*------------------------------------------;
*---------------- 2016 data----------------;
*------------------------------------------;
clear;
set memory 300m;
use `wave13d'H16A_R; * get various demographics;
keep HHID PN;

* generate placeholders;
gen house13=.;
gen mort13=.;
gen re13=.;
gen wheels13=.;
gen liquid13=.;
gen IRA13=.;
gen stock13=.;
gen bus13=.;
gen bonds13=.;
gen trust13=.;
gen exasset13=.;
gen debts13=.;
gen nohouse13=.;
gen assets13=.;

gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;
sort HHID PN;
merge HHID PN using `saved'asset;
drop _merge;
sort HHID PN;
sleep 1000;
save `saved'asset, replace;
*------------------------------------------;


*------------------------------------------;
*---------------- 2018 data----------------;
*------------------------------------------;
clear;
set memory 300m;
use `wave14d'h18a_r; * get various demographics;     
keep hhid pn;

* generate placeholders;
gen house14=.;
gen mort14=.;
gen re14=.;
gen wheels14=.;
gen liquid14=.;
gen IRA14=.;
gen stock14=.;
gen bus14=.;
gen bonds14=.;
gen trust14=.;
gen exasset14=.;
gen debts14=.;
gen nohouse14=.;
gen assets14=.;

gen HHID=real(hhid);
drop hhid;
gen PN=real(pn);
drop pn;
sort HHID PN;
merge HHID PN using `saved'asset;
drop _merge;
sort HHID PN;
sleep 1000;
save `saved'asset, replace;
*------------------------------------------;
*------------------------------------------;
*---------------- 2020 data----------------;
*------------------------------------------;
if $INCLUDE2020 {; 
disp "Doing 2020 processing..." ;
clear;
set memory 300m;
use `wave15d'h20a_r; * get various demographics;     
keep hhid pn;

* generate placeholders;
gen house15=.;
gen mort15=.;
gen re15=.;
gen wheels15=.;
gen liquid15=.;
gen IRA15=.;
gen stock15=.;
gen bus15=.;
gen bonds15=.;
gen trust15=.;
gen exasset15=.;
gen debts15=.;
gen nohouse15=.;
gen assets15=.;

gen HHID=real(hhid);
drop hhid;
gen PN=real(pn);
drop pn;
sort HHID PN;
merge HHID PN using `saved'asset;
drop _merge;
sort HHID PN;
sleep 1000;
save `saved'asset, replace;
};
*------------------------------------------;

***********************  AHEAD WAVE I *****************************************;



* Note: in this wave, "DK" and "RF" and "INAP" are all coded as ".". Therefore, we can't differentiate "DK" and "RF", although we can figure out "INAP";



clear;

set memory 300m;

use `aheadw1'bhh21;



*impute v1099x;
*changed all of the letters in the variable names in the bhh21 section and br21 section to capital letters when updating this file in 4-08 because new data has these variables capitalized;

replace V1099X=0 if OWN_RENT==2|OWN_RENT==7; * don't have a house or home; * checked right;

***************************

comment: in this wave, the imputation done by ISR is partial. 

For example, for those who doesn't have a home, the values should be 0, but the 

value are missing;



*house asset;

rename V1099X house1; 

*house mortgage; 



* impute v1126, the amount of the first mortgage;

replace V1126=0 if V1121==3|V1121==5|OWN_RENT==2|OWN_RENT==7; * not paying any mortgage or don't have a home; * checked right;



* impute v1131, the amount of the second mortgage;

replace V1131=0 if V1127==5; * don't have second mortgage or land contract; * checked right; 

replace V1131=0 if V1121==3|V1121==5|OWN_RENT==2|OWN_RENT==7; * not paying any mortgage or don't have a home; * checked right;





* impute v1135, the amount of the loan against the home;

replace V1135=0 if V1132==5; * no loan using the home as collateral;

replace V1135=0 if OWN_RENT==2|OWN_RENT==7; * not owning a home; * checked right;



* $ value of home mortgage;

gen mort1=V1126+V1131+V1135; 

************************

comment: Unlike other wave2,there is no fourth component of mort1, which is amount owed on the credit line;



* impute v1721x;

replace V1721X=0 if V1720==5; * no real estate; * checked right;

*******************************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1720 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;



* net value of real estate;  

rename V1721X re1;    

*********************

comment: There is no real estate mortgage in this wave;



* impute v1730x;

replace V1730X=0 if V1729==5; * don't own any business; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1729 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;





*business or farm;

rename V1730X bus1; 

* impute v1735X;

replace V1735X=0 if V1734==5; * don't have any IRA or so account; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 73 cases 

for v1734 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;



*IRA;

gen IRA1=V1735X; 

* impute v1744x;

replace V1744X=0 if V1743==5; * don't have any stocks; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1743 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;

    

*stock;

rename V1744X stock1;

* impute v1762x;

replace V1762X=0 if V1761==5; * don't have any bonds; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1761 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;



*bonds;

rename V1762X bonds1;

* impute v1750x;

replace V1750X=0 if V1749==5; * don't have any checking, saving or money market money; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1749 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;



* impute v1765x;

replace V1756X=0 if V1755==5; * don't have any T-bill or so; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 73 cases 

for v1755 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;



*liquid assets;

gen liquid1=V1750X+V1756X;

* impute v1725x;

replace V1725X=. if V1725F==2|V1725F==7|V1725F==8|V1725F==9; * real "INAP" cases; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1725f for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;



*transportation assets;

rename V1725X wheels1; 

* impute v1778x;

replace V1778X=0 if V1775==5; * no trust; * checked right;

* impute v1780x;

replace V1780X=0 if V1775==5; * no trust; * checked right;

replace V1780X=0 if V1779==1; * already told all of the trusts; * checked right;

replace V1780X=0 if V1779==5; * never told any trusts; * checked right;

*trust;

gen trust1=V1778X+V1780X;



* impute v1783x;

replace V1783X=0 if V1782==5; * no other assets; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1782 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;



* other assets;

rename V1783X exasset1; 

* impute v1788x;

replace V1788X=0 if V1787==5; * no debts; * checked right;

*********************

comment: here the imputation done by ISR is partial. Also, there are 74 cases 

for v1787 for "R is not financial respondent" or "partial interview", which I can't differentiate from the code-book. So I set them as missing value cases;

     

* debts;

rename V1788X debts1; 

* total non-house asset;        

gen nohouse1=re1+wheels1+liquid1+IRA1+stock1+bus1+bonds1+exasset1-debts1;

* total asset;

gen assets1=house1+nohouse1-mort1;

keep HHID BSUBHH house1  re1 mort1 wheels1 liquid1 IRA1 stock1 bus1 bonds1 trust1 exasset1 debts1 nohouse1 assets1;

summ;

sort HHID BSUBHH ;
sleep 1000;
save `aheadw1'temp, replace;


summ wheels1;

clear;

set memory 300m;

use `aheadw1'br21;


************************

comment:get PN variable from the above file;

keep HHID BSUBHH PN;

sort HHID BSUBHH; 

merge HHID BSUBHH using `aheadw1'temp;

drop _merge;

drop BSUBHH;

*rename hhid HHID;

*rename pn PN;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

gen temp=real(HHID);

drop HHID;

gen HHID=temp;

drop temp;

summ wheels1 HHID PN;

sort HHID PN;
sleep 1000;
save `aheadw1'asset, replace;

drop _all;







**********************  AHEAD WAVE II ****************************;





*****  pulling all the imputed data together;

clear;

set memory 300m;

*change filename that is used from ahd2ex (which doesn't exist in the new files) to A95E_R (the suspected new equivalent);
*use `aheadw2'ahd2ex; * get PN variable from the above file;
use `aheadw2'A95E_R; * get PN variable from the above file;


keep HHID DSUBHH  PN;

sort HHID DSUBHH; 
sleep 1000;
save `aheadw2'temp, replace;

drop _all;

clear;

set memory 300m;

*change filename that is used from ahd2fx (which doesn't exist in the new files) to a95i_fh (the suspected new equivalent);
*use `aheadw2'ahd2fx;
use `aheadw2'a95i_fh     ;

sort HHID DSUBHH;

merge HHID DSUBHH using `aheadw2'temp;

drop _merge;

gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;

sort HHID DSUBHH;

count;
sleep 1000;
save `aheadw2'temp, replace;

drop _all;

clear;

set memory 300m;

*change filename that is used from ahd2jx (which doesn't exist in the new files) to a95i_jh (the suspected new equivalent);
*use `aheadw2'ahd2jx;
use `aheadw2'a95i_jh;

count;

gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;

sort HHID DSUBHH; 

merge HHID DSUBHH using `aheadw2'temp;

drop _merge;

sort HHID DSUBHH; 
sleep 1000;
save `aheadw2'temp, replace;

clear;

set memory 300m;

*change filename that is used from ahd2nx (which doesn't exist in the new files) to A95N_H (the suspected new equivalent);
*use `aheadw2'ahd2nx;
use `aheadw2'A95N_H;

count;

gen temp=real(HHID);
drop HHID; 
gen HHID=temp;
drop temp;

sort HHID DSUBHH; 

merge HHID DSUBHH using `aheadw2'temp;

drop _merge;

sort HHID PN;
sleep 1000;
save `aheadw2'temp, replace;

drop _all;




clear;

set memory 300m;

use `aheadw2'temp;

*house asset;

rename D2246X house2; 

*house mortgage; 

gen mort2=D2256X+D2263X+D2270X+D2277X; 

*real estate;  

gen re2=D2435X+D3965X;    

*real estate mortgage;

rename D2445X remort2;    

**********************

Comment: for each observation, other "owed on second house" variables all have missing values,

 and the bracket-unfolding variables for them all have missing values too.;



*business or farm;

rename D4006X bus2;           

*IRA;

gen IRA2=D4048X+D4090X+D4129X;     

*stock;

rename D4339X stock2;      

*bonds;

rename D4382X bonds2;

*liquid assets;

gen liquid2=D4425X+D4464X;    

*transportation assets;

rename D4500X wheels2; 

*trust;

rename D4712X trust2; 

*other assets;

rename D4513X exasset2;
       

*debts;

rename D4726X debts2; 

*total non-house asset;        

gen nohouse2=re2+wheels2+liquid2+IRA2+stock2+bus2+bonds2+exasset2-debts2-remort2;

*total asset;

gen assets2=house2+nohouse2-mort2;

gen temp=real(PN);

drop PN;

gen PN=temp;

drop temp;

keep HHID PN house2  re2 mort2 remort2 wheels2 liquid2 IRA2 stock2 bus2 

bonds2 trust2 exasset2 debts2 nohouse2 assets2; 

summ;

sort HHID PN;


merge HHID PN using `aheadw1'asset;

drop _merge;

* rename AHEAD variables for merging;

rename house1 aahouse1;

rename re1 aare1;

rename mort1 aamort1;

rename wheels1 aawhee1;

rename liquid1 aaliqu1;

rename IRA1 aaIRA1;

rename stock1 aastock1;

rename bus1 aabus1;

rename bonds1 aabonds1;

rename trust1 aatrust1;

rename exasset1 aaexass1;

rename debts1 aadebts1;

rename nohouse1 aanohou1;

rename assets1 aaasse1;

rename house2 aahouse2;

rename re2 aare2;

rename mort2 aamort2;

rename remort2 aaremor2;

rename wheels2 aawhee2;

rename liquid2 aaliqu2;

rename IRA2 aaIRA2;

rename stock2 aastock2;

rename bus2 aabus2;

rename bonds2 aabonds2;

rename trust2 aatrust2;

rename exasset2 aaexass2;

rename debts2 aadebts2;

rename nohouse2 aanohou2;

rename assets2 aaasse2;

summ;


sort HHID PN;

sleep 1000;
save `aheadw2'asset, replace; 








**************  merge AHEAD data to HRS data ******************************;




* merge the AHEAD asset.dta file to the HRS asset.dta file here;

clear;


set mem 300m;


use `saved'asset;


sort HHID PN;


merge HHID PN using `aheadw2'asset;


drop _merge;



* replace missing HRS WAVE I and WAVE II values with AHEAD WAVE I and WAVE II 

values;



replace house1=aahouse1 if house1==. & aahouse1~=.;

replace re1=aare1 if re1==. & aare1~=.;

replace mort1=aamort1 if mort1==. & aamort1~=.;

replace wheels1=aawhee1 if wheels1==. & aawhee1~=.;

replace liquid1=aaliqu1 if liquid1==. & aaliqu1~=.;

replace IRA1=aaIRA1 if IRA1==. & aaIRA1~=.;

replace stock1=aastock1 if stock1==. & aastock1~=.;

replace bus1=aabus1 if bus1==. & aabus1~=.;

replace bonds1=aabonds1 if bonds1==. & aabonds1~=.;

replace trust1=aatrust1 if trust1==. & aatrust1~=.;

replace exasset1=aaexass1 if exasset1==. & aaexass1~=.;

replace debts1=aadebts1 if debts1==. & aadebts1~=.;

replace nohouse1=aanohou1 if nohouse1==. & aanohou1~=.;

replace assets1=aaasse1 if assets1==. & aaasse1~=.;

summ house2 aahouse2;

replace house2=aahouse2 if house2==. & aahouse2~=.;

replace re2=aare2 if re2==. & aare2~=.;

replace mort2=aamort2 if mort2==. & aamort2~=.;

replace remort2=aaremor2 if remort2==. & aaremor2~=.;

replace wheels2=aawhee2 if wheels2==. & aawhee2~=.;

replace liquid2=aaliqu2 if liquid2==. & aaliqu2~=.;

replace IRA2=aaIRA2 if IRA2==. & aaIRA2~=.;

replace stock2=aastock2 if stock2==. & aastock2~=.;

replace bus2=aabus2 if bus2==. & aabus2~=.;

replace bonds2=aabonds2 if bonds2==. & aabonds2~=.;

replace trust2=aatrust2 if trust2==. & aatrust2~=.;

replace exasset2=aaexass2 if exasset2==. & aaexass2~=.;

replace debts2=aadebts2 if debts2==. & aadebts2~=.;

replace nohouse2=aanohou2 if nohouse2==. & aanohou2~=.;

replace assets2=aaasse2 if assets2==. & aaasse2~=.;


drop aa*; * drop AHEAD variables;



* no more asset imputations ;
* as a result, no more aflag;
sort HHID PN;

sleep 1000;
save `saved'asset, replace;


summ;


cap log close;

*drop _all;
* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(asset.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'asset.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(asset.xlsx) sheetname(Old);












